import 'dotenv/config';
import { pool } from './db';

async function main() {
  try {
    const conn = await pool.getConnection();
    const [rows] = await conn.query('SELECT 1 AS ok');
    conn.release();
    console.log('DB connection OK:', rows);
    process.exit(0);
  } catch (err) {
    console.error('DB connection FAILED:', err);
    process.exit(1);
  }
}

main();
