import cors from 'cors';
import 'dotenv/config';
import express from 'express';
import categoriesRouter from './categories';
import { ensureSchema } from './db';
import productsRouter from './products';

const app = express();

app.use(cors({ origin: '*', methods: ['GET','POST','PUT','PATCH','DELETE','OPTIONS'] }));
app.use(express.json());

app.get('/health', (_req, res) => res.json({ ok: true }));
app.use('/api/products', productsRouter);
app.use('/api/categories', categoriesRouter);

const PORT = Number(process.env.PORT || 3000);

ensureSchema()
  .then(() => app.listen(PORT, () => console.log(`API listening on :${PORT}`)))
  .catch((err) => {
    console.error('Failed to ensure schema', err);
    process.exit(1);
  });
